#ifndef __DX_DAEMON_H__
#define __DX_DAEMON_H__

/* size of the EI_IDENT field in ELF */
#define EI_NIDENT                             16

/* the tupe of the section etnry that defined section where the signature and keys are kept */
#define DX_SIGN_SECTION_TYPE                  (0x80000000 + ('d' << 8) + 'x')

/* the path of the file that will be used for socket communication */
#define DX_DM_SOCK_PATH                       "/root/dx_daemon_sock"

/* path for connection to the driver */
#define DX_DM_SEP_DRIVER_PATH                 "/dev/sep_sec_singleton_driver"

/* the depth of backlog for listen command */
#define DX_DM_LISTEN_BACKLOG                  5

/* siz eof the buffer used for storing the data that will be cryoted by SEP */
#define DX_DM_DATA_BUFFER_SIZE                1024

/* maximum number of concurretnyl connected application */
#define DX_DM_MAX_NUM_CONNECTED_APPLICATION   10

/* the maximum size of modulus in bytes - 512 bytes = 2048 bits */
#define DX_MAX_PK_MODULUS_SIZE_IN_BYTES       256

/* the maximum size of exponent in bytes - 512 bytes = 2048 bits */
#define DX_MAX_PK_EXPONENT_SIZE_IN_BYTES      256

/* the maximum length of the caller id string */ 
#define DX_DM_CALLER_ID_STRING_LEN_IN_BYTES   60

/* length of signature in bytes */
#define DX_DM_MAX_SIGN_LEN_IN_BYTES           256


/* enum for the command ids of the application's requests */
typedef enum
{
  CALLER_ID_CMD = 1,
  
  LAST_COMMAND_CMD = 0xFFFFFFFF
  
}DX_DM_COMMAND_ID_EN;

/* struct that defines message request from application to daemon */
typedef struct _dx_dm_app_request
{
  DX_DM_COMMAND_ID_EN command_id;
  
  union
  {
    
  }data;
}dx_dm_app_request;

/* struct that defines the reply from daemon to application */
typedef struct _dx_dm_app_reply
{
  /* the same id as in command */
  DX_DM_COMMAND_ID_EN replyId;
  
  /* status of the command execution */
  int                 status;
  
  union
  {
    
  }data;
  
}dx_dm_app_reply;

/* elf header struct */
typedef struct _elf_hdr_st{
  unsigned char   e_ident[EI_NIDENT];
  unsigned short  e_type;
  unsigned short  e_machine;
  unsigned long   e_version;
  unsigned long   e_entry;
  unsigned long   e_phoff;
  unsigned long   e_shoff;
  unsigned long   e_flags;
  unsigned short  e_ehsize;
  unsigned short  e_phentsize;
  unsigned short  e_phnum;
  unsigned short  e_shentsize;
  unsigned short  e_shnum;
  unsigned short  e_shtrndx;
}elf_hdr_st;

/* elf section header entry struct */
typedef struct _elf32_shdr_st{
  unsigned long   sh_name;
  unsigned long   sh_type;
  unsigned long   sh_flags;
  unsigned long   sh_addr;
  unsigned long   sh_offset;
  unsigned long   sh_size;
  unsigned long   sh_link;
  unsigned long   sh_info;
  unsigned long   sh_addralign;
  unsigned long   sh_entsize;
}elf32_shdr_st;

/* the structure that defines a RSA public key */
typedef struct _dx_pk_st
{
  /* modulus size in bytes */
  unsigned long modulus_size;
  
  /* exponent size in bytes */
  unsigned long exponent_size;
  /* public key modulus */
  unsigned char modulus[DX_MAX_PK_MODULUS_SIZE_IN_BYTES];
  
  /* public key exponent */
  unsigned char pk_exponent[DX_MAX_PK_EXPONENT_SIZE_IN_BYTES];
}dx_pk_st;

/* discretix application sign section structure */
typedef struct _dx_app_sign_section_st
{
  /* application public key */
  dx_pk_st      app_pk;
  
  /*length of caller id string in bytes */
  unsigned long callerIdSizeInBytes;
  
  /* caller id string */
  unsigned char callerId[DX_DM_CALLER_ID_STRING_LEN_IN_BYTES]; 
  
  /* number of authorized publick keys for DDLs authentication */
  unsigned long numDLLPks;
  
}dx_app_sign_section_st;

/* dll sign section structure */
typedef struct _dx_dll_sign_section_st
{  
  /* DLL public key */
  dx_pk_st      dll_pk;
  
}dx_dll_sign_section_st;


#endif
